#!/system/bin/sh

TARGET_DIR="/system"
STORAGE_DIR=""
TAR_PKG=""


function add_pkg_to_misc(){
    echo -en $1\\n\\x00 >> $2
}

function get_package_location(){
    a=$(cat /proc/$PPID/cmdline)
    a=${a#*/}
    a=${a#*/}
    a=${a#*/}
    root=${a%%/*}
    file_full=/$a
    file_noroot=${a#*/}
    echo -en root=$root\\nfile_full=$file_full\\nfile_noroot=$file_noroot\\n > $TARGET_DIR/pkg_props.txt
}

function get_package_location_non_sideload(){

    a=$(cat /proc/$PPID/cmdline)

    #b=/internalsd${a#*/internalsd}           # check internalsd first
    b=${a#*/internalsd}
    c=/internalsd$b


    if [[ "$a" == "$b" ]] ; then
    #b=/sdcard${a#*/sdcard}               # check sdcard next
    b=${a#*/sdcard}
    c=/sdcard$b
    fi

    if [[ "$a" == "$b" ]] ; then
    #b=/data${a#*/data}                 # if we still haven't made a change, use data
    b=${a#*/data}
    c=/data$b
    fi

    if [[ "$a" == "$b" ]] ; then
    b=${a#*/tmp}
    c=/tmp/update.zip
    fi

    file_full=$c

    root=${b%%/*}
    file_noroot=${b##*/}
    echo -en root=$root\\nfile_full=$file_full\\nfile_noroot=$file_noroot\\n > $TARGET_DIR/pkg_props.txt
}

function get_package_source_path(){

    TAR_PKG=$1

    STORAGE_DIR="/sdcard"
    find_target_file $STORAGE_DIR
    STORAGE_DIR="/internalsd"
    find_target_file $STORAGE_DIR

    #SOURCE_DIR=""

    #if [ -e /sdcard/FullPackageUpdate.zip ]; then
    #    SOURCE_DIR=sdcard
    #elif [ -e /internalsd/FullPackageUpdate.zip ]; then
    #    SOURCE_DIR=internalsd
    #fi

    #echo -en "DIR=$SOURCE_DIR" > $TARGET_DIR/pkg_path.txt
}

function find_target_file(){

        #echo "find_target_file for $1"

        for idx in $(/system/bin/ls $1)
        do
                if [ -d "$1/$idx" ]; then
                        #echo "$1/$idx is directory"
                        find_target_file $1/$idx
                elif [ -f "$1/$idx" ]; then
                        #echo "$1/$idx is file"
                        /system/bin/cmp "$1/$idx" "$TAR_PKG" > /dev/null
                        if [ "$?" = "0" ]; then
                                #echo "Got the file you need $1/$idx"
                                if [ "$STORAGE_DIR" == "/sdcard" ]; then
                                    /system/bin/mv $1/$idx /sdcard/update.zip
                                    echo -en "TAR_PKG=/storage/sdcard1/update.zip" > $TARGET_DIR/pkg_path.txt
                                else
                                    echo -en "TAR_PKG=$1/$idx" > $TARGET_DIR/pkg_path.txt
                                fi
                                exit 0
                        fi
                #else
                        #echo "$1/$idx is neither file nor directory"
                fi

        done

        echo -en "TAR_PKG=cannot_find_the_package" > $TARGET_DIR/pkg_path.txt
}

function get_part12_size(){
    echo -en "SIZE=$(cat /sys/block/mmcblk0/mmcblk0p12/size)" > $TARGET_DIR/part12_size.txt
}

case $1 in

    add_pkg_to_misc)
        add_pkg_to_misc $2 $3
        ;;

    get_package_location)
        get_package_location
        ;;

    get_package_location_non_sideload)
        get_package_location_non_sideload
        ;;

    get_package_source_path)
        get_package_source_path $2
        ;;

    get_part12_size)
        get_part12_size
        ;;
esac
